/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.data.builder;

import com.endilcrafter.farmersplus.common.registry.PlusRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MillstoneRecipeBuilder {
    private final List<ChanceResult> results = new ArrayList<ChanceResult>(4);
    private final Ingredient ingredient;
    private String soundEventID;

    private MillstoneRecipeBuilder(Ingredient ingredient, ItemLike mainResult, int count, float chance) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)mainResult.m_5456_(), count), chance));
        this.ingredient = ingredient;
    }

    public static MillstoneRecipeBuilder millingRecipe(Ingredient ingredient, ItemLike mainResult, int count) {
        return new MillstoneRecipeBuilder(ingredient, mainResult, count, 1.0f);
    }

    public static MillstoneRecipeBuilder millingRecipe(Ingredient ingredient, ItemLike mainResult, int count, int chance) {
        return new MillstoneRecipeBuilder(ingredient, mainResult, count, chance);
    }

    public static MillstoneRecipeBuilder millingRecipe(Ingredient ingredient, ItemLike mainResult) {
        return new MillstoneRecipeBuilder(ingredient, mainResult, 1, 1.0f);
    }

    public MillstoneRecipeBuilder addResult(ItemLike result) {
        return this.addResult(result, 1);
    }

    public MillstoneRecipeBuilder addResult(ItemLike result, int count) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)result.m_5456_(), count), 1.0f));
        return this;
    }

    public MillstoneRecipeBuilder addResultWithChance(ItemLike result, float chance) {
        return this.addResultWithChance(result, chance, 1);
    }

    public MillstoneRecipeBuilder addResultWithChance(ItemLike result, float chance, int count) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)result.m_5456_(), count), chance));
        return this;
    }

    public MillstoneRecipeBuilder addSound(String soundEventID) {
        this.soundEventID = soundEventID;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_());
        this.build(consumerIn, "farmersplus:milling/" + location.m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Milling Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.ingredient, this.results, this.soundEventID == null ? "" : this.soundEventID));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final List<ChanceResult> results;
        private final String soundEventID;

        public Result(ResourceLocation idIn, Ingredient ingredientIn, List<ChanceResult> resultsIn, String soundEventIDIn) {
            this.id = idIn;
            this.ingredient = ingredientIn;
            this.results = resultsIn;
            this.soundEventID = soundEventIDIn;
        }

        public void m_7917_(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            arrayIngredients.add(this.ingredient.m_43942_());
            json.add("ingredients", (JsonElement)arrayIngredients);
            JsonArray arrayResults = new JsonArray();
            for (ChanceResult result : this.results) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)result.getStack().m_41720_()).toString());
                if (result.getStack().m_41613_() > 1) {
                    jsonobject.addProperty("count", (Number)result.getStack().m_41613_());
                }
                if (result.getChance() < 1.0f) {
                    jsonobject.addProperty("chance", (Number)Float.valueOf(result.getChance()));
                }
                arrayResults.add((JsonElement)jsonobject);
            }
            json.add("result", (JsonElement)arrayResults);
            if (!this.soundEventID.isEmpty()) {
                json.addProperty("sound", this.soundEventID);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)PlusRecipeSerializers.MILLING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

